
//Chris' WinGlide enhancements
//Copr. 1999 Chris Dohnal (cwdohnal@ucdavis.edu)

#ifdef IMPORTS_C
#define DECL_TEMP
#else
#define DECL_TEMP extern
#endif


DECL_TEMP void
(*_grDrawPoint)( const void *pt );

DECL_TEMP void
(*_grDrawLine)( const void *v1, const void *v2 );

DECL_TEMP void
(*_grDrawTriangle)( const void *a, const void *b, const void *c );

DECL_TEMP void
(*_grVertexLayout)(FxU32 param, FxI32 offset, FxU32 mode);

DECL_TEMP void 
(*_grDrawVertexArray)(FxU32 mode, FxU32 Count, void *pointers);

DECL_TEMP void 
(*_grDrawVertexArrayContiguous)(FxU32 mode, FxU32 Count, void *pointers, FxU32 stride);

DECL_TEMP void
(*_grAADrawTriangle)(
                 const void *a, const void *b, const void *c,
                 FxBool ab_antialias, FxBool bc_antialias, FxBool ca_antialias
                 );

DECL_TEMP void
(*_grBufferClear)( GrColor_t color, GrAlpha_t alpha, FxU32 depth );

DECL_TEMP void
(*_grBufferSwap)( FxU32 swap_interval );

DECL_TEMP void
(*_grRenderBuffer)( GrBuffer_t buffer );

typedef void (*GrErrorCallbackFnc_t)( const char *string, FxBool fatal );

DECL_TEMP void 
(*_grErrorSetCallback)( GrErrorCallbackFnc_t fnc );

DECL_TEMP void 
(*_grFinish)(void);

DECL_TEMP void 
(*_grFlush)(void);

DECL_TEMP GrContext_t 
(*_grSstWinOpen)(
          FxU32                hWnd,
          GrScreenResolution_t screen_resolution,
          GrScreenRefresh_t    refresh_rate,
          GrColorFormat_t      color_format,
          GrOriginLocation_t   origin_location,
          int                  nColBuffers,
          int                  nAuxBuffers);

DECL_TEMP FxBool
(*_grSstWinClose)( GrContext_t context );

DECL_TEMP FxBool
(*_grSelectContext)( GrContext_t context );

DECL_TEMP void
(*_grSstOrigin)(GrOriginLocation_t  origin);

DECL_TEMP void 
(*_grSstSelect)( int which_sst );

DECL_TEMP void
(*_grAlphaBlendFunction)(
                     GrAlphaBlendFnc_t rgb_sf,   GrAlphaBlendFnc_t rgb_df,
                     GrAlphaBlendFnc_t alpha_sf, GrAlphaBlendFnc_t alpha_df
                     );

DECL_TEMP void
(*_grAlphaCombine)(
               GrCombineFunction_t function, GrCombineFactor_t factor,
               GrCombineLocal_t local, GrCombineOther_t other,
               FxBool invert
               );

DECL_TEMP void
(*_grAlphaControlsITRGBLighting)( FxBool enable );

DECL_TEMP void
(*_grAlphaTestFunction)( GrCmpFnc_t function );

DECL_TEMP void
(*_grAlphaTestReferenceValue)( GrAlpha_t value );

DECL_TEMP void 
(*_grChromakeyMode)( GrChromakeyMode_t mode );

DECL_TEMP void 
(*_grChromakeyValue)( GrColor_t value );

DECL_TEMP void 
(*_grClipWindow)( FxU32 minx, FxU32 miny, FxU32 maxx, FxU32 maxy );

DECL_TEMP void 
(*_grColorCombine)(
               GrCombineFunction_t function, GrCombineFactor_t factor,
               GrCombineLocal_t local, GrCombineOther_t other,
               FxBool invert );

DECL_TEMP void
(*_grColorMask)( FxBool rgb, FxBool a );

DECL_TEMP void 
(*_grCullMode)( GrCullMode_t mode );

DECL_TEMP void 
(*_grConstantColorValue)( GrColor_t value );

DECL_TEMP void 
(*_grDepthBiasLevel)( FxI32 level );

DECL_TEMP void 
(*_grDepthBufferFunction)( GrCmpFnc_t function );

DECL_TEMP void 
(*_grDepthBufferMode)( GrDepthBufferMode_t mode );

DECL_TEMP void 
(*_grDepthMask)( FxBool mask );

DECL_TEMP void 
(*_grDisableAllEffects)( void );

DECL_TEMP void 
(*_grDitherMode)( GrDitherMode_t mode );

DECL_TEMP void 
(*_grFogColorValue)( GrColor_t fogcolor );

DECL_TEMP void 
(*_grFogMode)( GrFogMode_t mode );

DECL_TEMP void 
(*_grFogTable)( const GrFog_t ft[] );

DECL_TEMP void 
(*_grLoadGammaTable)( FxU32 nentries, FxU32 *red, FxU32 *green, FxU32 *blue);

DECL_TEMP void
(*_grSplash)(float x, float y, float width, float height, FxU32 frame);

DECL_TEMP FxU32 
(*_grGet)( FxU32 pname, FxU32 plength, FxI32 *params );

//DECL_TEMP const char * 
//(*_grGetString)( FxU32 pname );
DECL_TEMP char * 
(*_grGetString)( FxU32 pname );

DECL_TEMP FxI32 
(*_grQueryResolutions)( const GrResolution *resTemplate, GrResolution *output );

DECL_TEMP FxBool 
(*_grReset)( FxU32 what );

DECL_TEMP GrProc
(*_grGetProcAddress)( char *procName );

DECL_TEMP void 
(*_grEnable)( GrEnableMode_t mode );

DECL_TEMP void 
(*_grDisable)( GrEnableMode_t mode );

DECL_TEMP void 
(*_grCoordinateSpace)( GrCoordinateSpaceMode_t mode );

DECL_TEMP void 
(*_grDepthRange)( FxFloat n, FxFloat f );

DECL_TEMP void 
(*_grViewport)( FxI32 x, FxI32 y, FxI32 width, FxI32 height );

DECL_TEMP FxU32 
(*_grTexCalcMemRequired)(
                     GrLOD_t lodmin, GrLOD_t lodmax,
                     GrAspectRatio_t aspect, GrTextureFormat_t fmt);

DECL_TEMP FxU32 
(*_grTexTextureMemRequired)( FxU32     evenOdd,
                                 GrTexInfo *info   );

DECL_TEMP FxU32 
(*_grTexMinAddress)( GrChipID_t tmu );

DECL_TEMP FxU32 
(*_grTexMaxAddress)( GrChipID_t tmu );

DECL_TEMP void 
(*_grTexNCCTable)( GrNCCTable_t table );

DECL_TEMP void 
(*_grTexSource)( GrChipID_t tmu,
             FxU32      startAddress,
             FxU32      evenOdd,
             GrTexInfo  *info );

DECL_TEMP void 
(*_grTexClampMode)(
               GrChipID_t tmu,
               GrTextureClampMode_t s_clampmode,
               GrTextureClampMode_t t_clampmode
               );

DECL_TEMP void 
(*_grTexCombine)(
             GrChipID_t tmu,
             GrCombineFunction_t rgb_function,
             GrCombineFactor_t rgb_factor, 
             GrCombineFunction_t alpha_function,
             GrCombineFactor_t alpha_factor,
             FxBool rgb_invert,
             FxBool alpha_invert
             );

DECL_TEMP void 
(*_grTexDetailControl)(
                   GrChipID_t tmu,
                   int lod_bias,
                   FxU8 detail_scale,
                   float detail_max
                   );

DECL_TEMP void 
(*_grTexFilterMode)(
                GrChipID_t tmu,
                GrTextureFilterMode_t minfilter_mode,
                GrTextureFilterMode_t magfilter_mode
                );


DECL_TEMP void 
(*_grTexLodBiasValue)(GrChipID_t tmu, float bias );

DECL_TEMP void 
(*_grTexDownloadMipMap)( GrChipID_t tmu,
                     FxU32      startAddress,
                     FxU32      evenOdd,
                     GrTexInfo  *info );

DECL_TEMP void 
(*_grTexDownloadMipMapLevel)( GrChipID_t        tmu,
                          FxU32             startAddress,
                          GrLOD_t           thisLod,
                          GrLOD_t           largeLod,
                          GrAspectRatio_t   aspectRatio,
                          GrTextureFormat_t format,
                          FxU32             evenOdd,
                          void              *data );

DECL_TEMP FxBool 
(*_grTexDownloadMipMapLevelPartial)( GrChipID_t        tmu,
                                 FxU32             startAddress,
                                 GrLOD_t           thisLod,
                                 GrLOD_t           largeLod,
                                 GrAspectRatio_t   aspectRatio,
                                 GrTextureFormat_t format,
                                 FxU32             evenOdd,
                                 void              *data,
                                 int               start,
                                 int               end );

DECL_TEMP void
(*_grTexDownloadTable)( GrTexTable_t type, 
                    void         *data );

DECL_TEMP void
(*_grTexDownloadTablePartial)( GrTexTable_t type, 
                           void         *data,
                           int          start,
                           int          end );

DECL_TEMP void 
(*_grTexMipMapMode)( GrChipID_t     tmu, 
                 GrMipMapMode_t mode,
                 FxBool         lodBlend );

DECL_TEMP void 
(*_grTexMultibase)( GrChipID_t tmu,
                FxBool     enable );

DECL_TEMP void
(*_grTexMultibaseAddress)( GrChipID_t       tmu,
                       GrTexBaseRange_t range,
                       FxU32            startAddress,
                       FxU32            evenOdd,
                       GrTexInfo        *info );

DECL_TEMP FxBool
(*_grLfbLock)( GrLock_t type, GrBuffer_t buffer, GrLfbWriteMode_t writeMode,
           GrOriginLocation_t origin, FxBool pixelPipeline, 
           GrLfbInfo_t *info );

DECL_TEMP FxBool
(*_grLfbUnlock)( GrLock_t type, GrBuffer_t buffer );

DECL_TEMP void 
(*_grLfbConstantAlpha)( GrAlpha_t alpha );

DECL_TEMP void 
(*_grLfbConstantDepth)( FxU32 depth );

DECL_TEMP void 
(*_grLfbWriteColorSwizzle)(FxBool swizzleBytes, FxBool swapWords);

DECL_TEMP void
(*_grLfbWriteColorFormat)(GrColorFormat_t colorFormat);

DECL_TEMP FxBool
(*_grLfbWriteRegion)( GrBuffer_t dst_buffer, 
                  FxU32 dst_x, FxU32 dst_y, 
                  GrLfbSrcFmt_t src_format, 
                  FxU32 src_width, FxU32 src_height, 
                  FxBool pixelPipeline,
                  FxI32 src_stride, void *src_data );

DECL_TEMP FxBool
(*_grLfbReadRegion)( GrBuffer_t src_buffer,
                 FxU32 src_x, FxU32 src_y,
                 FxU32 src_width, FxU32 src_height,
                 FxU32 dst_stride, void *dst_data );

DECL_TEMP void
(*_grGlideInit)( void );

DECL_TEMP void
(*_grGlideShutdown)( void );

DECL_TEMP void
(*_grGlideGetState)( void *state );

DECL_TEMP void
(*_grGlideSetState)( const void *state );

DECL_TEMP void
(*_grGlideGetVertexLayout)( void *layout );

DECL_TEMP void
(*_grGlideSetVertexLayout)( const void *layout );


DECL_TEMP void 
(*_guGammaCorrectionRGB)( FxFloat red, FxFloat green, FxFloat blue );

DECL_TEMP float
(*_guFogTableIndexToW)( int i );

DECL_TEMP void
(*_guFogGenerateExp)( GrFog_t *fogtable, float density );

DECL_TEMP void
(*_guFogGenerateExp2)( GrFog_t *fogtable, float density );

DECL_TEMP void
(*_guFogGenerateLinear)(GrFog_t *fogtable,
                    float nearZ, float farZ );

//DECL_TEMP int
//(*_guEncodeRLE16)( void *dst, 
//               void *src, 
//               FxU32 width, 
//               FxU32 height );

DECL_TEMP FxBool
(*_gu3dfGetInfo)( const char *filename, Gu3dfInfo *info );

DECL_TEMP FxBool
(*_gu3dfLoad)( const char *filename, Gu3dfInfo *data );
